;*********************************
;* Jungle Jag - JagCode 500 Game *
;*********************************
;
; by Cedric Bourse, (a.k.a Orion_) [2007]
;
; http://onorisoft.info/
;
; This Source Code is licensed under the term of the following Creative Commons License:
; http://creativecommons.org/licenses/by-nc/3.0/
;
; You are free:
;  * to Share : to copy, distribute and transmit the work
;  * to Remix : to adapt the work
;
; Under the following conditions:
;  * Attribution. You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).
;  * Noncommercial. You may not use this work for commercial purposes.
;  * For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.
;  * Any of the above conditions can be waived if you get permission from the copyright holder.
;  * Nothing in this license impairs or restricts the author's moral rights.
;

	.include	"jaguar.inc"

	.68000
	.text

	.include	"init.s"

Start:
	bsr	InitVideo

	bsr	UnSetSpriteList

	bsr	CopyGPUCode
	bsr	CopyDSPCode

	SetVideoMode	RGB16

	lea	font_palette,a0
	lea	FontPalette,a1
	moveq	#15,d0
	bsr	MakeClut24_16

	lea	ingame_palette,a0
	lea	GamePalette,a1
	move.w	#170,d0
	bsr	MakeClut24_16

	clr.w	phase

	; Start VBL Routine
	lea.l	VBLrout,a0
	bsr	InitVBLInt

	StartDSP

;*****************
;- Main 68k Loop -
;*****************

loop:
	stop	#$2000			; Stop the 68k !

	move.w	#$810e,JOYSTICK		; Read Pad 1, Arrow
	move.l	JOYSTICK,d7		; Get Buttons and Arrow states
	btst.l	#0,d7			; Test Pause Button
	bne.s	.ndbug

	move.w	#$1000,d0		; Hidden DBUG MODE ;)
.A:	dbra	d0,.A

	move.w	#$F800,BG		; VBL Measure

.ndbug:

;--------
; Phases:
; 0 - Menu Init
; 1 - Menu Fade In
; 2 - Menu
; 3 - Menu Fade Out
; 4 - Level Loading
; 5 - Level Fade In
; 6 - Level Play
; 7 - Level FadeOut -> Text Loading
; 8 - Text FadeIn
; 9 - Text Valid
; A - Text FadeOut
; B - Menu Fade Out -> Credits Init
; C - Credits Fade In
; D - Credits Valid
; E - Credits Fade Out

	tst.w	phase
	bne.s	.n0

	move.w	#3,coeur	; number of lives for the entire game !

	bsr	InitMenu
	addq.w	#1,phase

	bra	.finphase
.n0:
;---
	cmpi.w	#1,phase
	bne.s	.n1

	moveq	#15,d0
	lea	FontPalette,a0
	bsr	FadeInCLUT

	subq.w	#4,fade_cnt
	moveq	#0,d0
	move.w	fade_cnt,d1
	bsr	SetSpriteY

	tst.w	fade_cnt
	bne	.finphase
	addq.w	#1,phase

	bra	.finphase
.n1:
;---
	cmpi.w	#2,phase
	bne.s	.n2

	bsr	Menu

	bra	.finphase
.n2:
;---
	cmpi.w	#3,phase
	bne.s	.n3

	moveq	#15,d0
	bsr	FadeOutCLUT

	subq.w	#4,fade_cnt
	moveq	#0,d0
	move.w	#256,d1
	sub.w	fade_cnt,d1
	bsr	SetSpriteY

	tst.w	fade_cnt
	bne	.finphase
	addq.w	#1,phase

	bra	.finphase
.n3:
;---
	cmpi.w	#4,phase
	bne.s	.n4

	move.w	level_n,d0
	add.w	d0,d0
	add.w	d0,d0
	lea	maplist,a0

	tst.l	0(a0,d0.w)	; no more level ?
	bne.s	.ll
	clr.w	phase		; return to menu
	clr.w	level_n
	bra	.finphase

.ll:	movea.l	0(a0,d0.w),a0
	bsr	LoadLevel

	addq.w	#1,phase
	move.w	#256,fade_cnt

	bra	.finphase
.n4:
;---
	cmpi.w	#5,phase
	bne.s	.n5

	move.w	#170,d0
	lea	GamePalette,a0
	bsr	FadeInCLUT

	subq.w	#4,fade_cnt
	moveq	#0,d0
	move.w	fade_cnt,d1
	bsr	SetSpriteY

	tst.w	fade_cnt
	bne	.finphase
	addq.w	#1,phase

	bra	.finphase
.n5:
;---
	cmpi.w	#6,phase
	bne.s	.n6

	bsr	GamePlay

	bra	.finphase
.n6:
;---
	cmpi.w	#7,phase
	bne	.n7

	move.w	#170,d0
	bsr	FadeOutCLUT

	subq.w	#4,fade_cnt
	moveq	#0,d0
	move.w	#256,d1
	sub.w	fade_cnt,d1
	bsr	SetSpriteY

	tst.w	fade_cnt
	bne	.finphase

	bsr	InitTextScreen

	lea	SFX_Win,a0
	lea	SFX_WinE,a1
	lea	winnertext,a4
	tst.b	game_over
	beq.s	.ngo
	lea	SFX_Lose,a0
	lea	SFX_LoseE,a1
	lea	gameovertext,a4
.ngo:	bsr	AddSound


; - End Game Text Show -

	move.w	level_n,d0
	addq.w	#1,d0
	add.w	d0,d0
	add.w	d0,d0
	lea	maplist,a0

	tst.l	0(a0,d0.w)	; no more level ?
	bne.s	.dadada

	lea	winnertextEnd1,a0
	bsr	RenderBigText
	lea	winnertextEnd2,a0
	bsr	RenderBigText
	lea	winnertextEnd3,a4

.dadada:
	movea.l	a4,a0
	bsr	RenderBigText

	addq.w	#1,phase
	move.w	#256,fade_cnt

	bra	.finphase
.n7:
;---
	cmpi.w	#8,phase
	bne.s	.n8

	moveq	#15,d0
	lea	FontPalette,a0
	bsr	FadeInCLUT

	subq.w	#4,fade_cnt
	moveq	#0,d0
	move.w	fade_cnt,d1
	bsr	SetSpriteY

	tst.w	fade_cnt
	bne	.finphase
	addq.w	#1,phase

	bra	.finphase
.n8:
;---
	cmpi.w	#9,phase
	bne.s	.n9

	move.w	#$810d,JOYSTICK		; Read Pad 1, B button
	move.l	JOYSTICK,d7		; Get B Button 0 = pressed, 1 = not pressed
	btst.l	#1,d7			; B Button (valid)
	bne	.finphase
	addq.w	#1,phase
	move.w	#256,fade_cnt
	lea	SFX_Valid,a0
	lea	SFX_ValidE,a1
	bsr	AddSound

	bra	.finphase
.n9:
;---
	cmpi.w	#10,phase
	bne.s	.nA

	moveq	#15,d0
	bsr	FadeOutCLUT

	subq.w	#4,fade_cnt
	moveq	#0,d0
	move.w	#256,d1
	sub.w	fade_cnt,d1
	bsr	SetSpriteY

	tst.w	fade_cnt
	bne	.finphase

	move.w	#4,phase
	addq.w	#1,level_n

	tst.b	game_over
	beq	.finphase

	clr.w	phase
	clr.w	level_n

	bra	.finphase
.nA:
;---
	cmpi.w	#11,phase
	bne.s	.nB

	moveq	#15,d0
	bsr	FadeOutCLUT

	subq.w	#4,fade_cnt
	moveq	#0,d0
	move.w	#256,d1
	sub.w	fade_cnt,d1
	bsr	SetSpriteY

	tst.w	fade_cnt
	bne	.finphase
	addq.w	#1,phase
	bsr	InitCredits

	bra	.finphase
.nB:
;---
	cmpi.w	#12,phase
	bne.s	.nC

	moveq	#15,d0
	lea	FontPalette,a0
	bsr	FadeInCLUT

	subq.w	#4,fade_cnt
	moveq	#0,d0
	move.w	fade_cnt,d1
	bsr	SetSpriteY

	tst.w	fade_cnt
	bne	.finphase
	addq.w	#1,phase

	bra	.finphase
.nC:
;---
	cmpi.w	#13,phase
	bne.s	.nD

	move.w	#$810d,JOYSTICK		; Read Pad 1, B button
	move.l	JOYSTICK,d7		; Get B Button 0 = pressed, 1 = not pressed
	btst.l	#1,d7			; B Button (valid)
	bne.s	.finphase
	addq.w	#1,phase
	move.w	#256,fade_cnt
	lea	SFX_Valid,a0
	lea	SFX_ValidE,a1
	bsr	AddSound

	bra.s	.finphase
.nD:
;---
	cmpi.w	#14,phase
	bne.s	.nE

	moveq	#15,d0
	bsr	FadeOutCLUT

	subq.w	#4,fade_cnt
	moveq	#0,d0
	move.w	#256,d1
	sub.w	fade_cnt,d1
	bsr	SetSpriteY

	tst.w	fade_cnt
	bne.s	.finphase
	clr.w	phase

.nE:


.finphase:

;--------

.dbug:
	move.w	#0,BG

	bra	loop

;	move.w	#$810e,JOYSTICK		; Read Pad 1, Arrow
;	move.l	JOYSTICK,d7		; Get Buttons and Arrow states
;	not.l	d7			; inverse: 1 = pressed, 0 = not pressed
;	btst.l	#0,d7			; Test Pause Button
;	beq	loop
;	move.l	#$E00008,-(a7)		; Clean Reset to BJL
;	rts


;***************
;- VBL Routine -
;***************

VBLrout:
	StartGPU	; GPU/Blitter SpriteList Update
	VBLIntAck
	rte

;***************


;************
;- Includes -
;************

; 68k Code
	.include	"op.s"
	.include	"loadlvl.s"
	.include	"gameplay.s"
	.include	"menu.s"
	.include	"sound.s"

; DSP Code
	.include	"dsp.s"

; GPU Code
	.include	"gpu.s"


;***************
;- Ram Data(s) -
;***************

	.include	"datas.s"
